#!/usr/bin/perl -w

#   The PerlGP Genetic Programming System
#   Copyright (C) 2003 Bob MacCallum
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License ($PERLGP_BASE/LICENSE) for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The original author's contact details are:
#   Bob MacCallum
#   Stockholm Bioinformatics Center
#   Stockholm University, 106 91 Stockholm, Sweden.
#   WWW: http://perlgp.org  EMAIL: info AT perlgp DOT org


use lib '.', $ENV{PERLGP_LIB} ||  die "
  PERLGP_LIB undefined
  please see README file concerning shell environment variables\n\n";

use Population;
use Individual;
use Algorithm;
use Cwd;

use Getopt::Long;
my $loop;
GetOptions(loop=>\$loop); # see NB below

if ($loop) { # keep running forever (without the -loop option of course)
  while (1) { # useful if you have unavoidable crashes
    system $0; # NB: no options passed on
    warn "perlgp crashed - restarting in 60 seconds...\n";
    sleep 60;
  }
}


# get the name of this run from the current directory.
# this will be used for filenames to save populations etc.
my ($exptid) = cwd() =~ m:([^/]+)$:;

# make an empty Population object
my $population = new Population( ExperimentId => $exptid,
			       );

# and fill it from disk or tar file
$population->repopulate();

# or fill it up with new Individuals
while ($population->countIndividuals() < $population->PopulationSize()) {
  $population->addIndividual(new Individual( Population => $population,
				             ExperimentId => $exptid,
			  DBFileStem => $population->findNewDBFileStem()));
}

my $algorithm = new Algorithm( Population => $population );

# run the algorithm!
$algorithm->run();



