#!/usr/bin/perl -w

#   The PerlGP Genetic Programming System
#   Copyright (C) 2003 Bob MacCallum
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License ($PERLGP_BASE/LICENSE) for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The original author's contact details are:
#   Bob MacCallum
#   Stockholm Bioinformatics Center
#   Stockholm University, 106 91 Stockholm, Sweden.
#   WWW: http://perlgp.org  EMAIL: info AT perlgp DOT org


use lib '.', $ENV{PERLGP_LIB} ||  die "
  PERLGP_LIB undefined
  please see README file concerning shell environment variables\n\n";

use Getopt::Long;
use Individual;
use Cwd;
use POSIX qw(tmpnam);

my ($help, $tree);
GetOptions(help=>\$help, tree=>\$tree);

my $file = shift;

die "usage: perlgp-show-prog.pl [-tree] filestem\n" if ($help || !$file);

my ($exptid) = cwd() =~ m:([^/]+)$:;

my ($filestem) = $file =~ /(.+?)(\.\w*)?$/;

my $ind = new Individual( Population => 'dummy',
			  ExperimentId => $exptid,
			  DBFileStem => $filestem );

if ($tree) {
  my $tmp = tmpnam();
  $ind->saveTree(Filename=>$tmp);
  system "daVinci $tmp";
  unlink $tmp;
} else {
  $ind->saveCode(Filename=>'-');
}
