#!/usr/bin/perl -w

#   The PerlGP Genetic Programming System
#   Copyright (C) 2003 Bob MacCallum
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License ($PERLGP_BASE/LICENSE) for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The original author's contact details are:
#   Bob MacCallum
#   Stockholm Bioinformatics Center
#   Stockholm University, 106 91 Stockholm, Sweden.
#   WWW: http://perlgp.org  EMAIL: info AT perlgp DOT org


use Cwd;

my $bdir = cwd();

push @ARGV, '.' unless (@ARGV);
foreach $edir (@ARGV) {

  chdir $edir;
  my $dir = cwd();
  ($dir) = $dir =~ m{/([^/]+)$};

  die "you're not in an experiment directory\n
usage: perlgp-wipe-expt.pl [ optional expt directories ]\n"
    unless (-e "Individual.pm" && -e "Algorithm.pm");

  die "PERLGP_SCRATCH not set\n" unless ($ENV{PERLGP_SCRATCH});


  system "rm -rf ./results $ENV{PERLGP_SCRATCH}/$dir";

  if ($ENV{PERLGP_POPS}) {
    system "rm -rf $ENV{PERLGP_POPS}/$dir.*";
  }
  chdir $bdir;

}
