package SupervisedLearning;

#   The PerlGP Genetic Programming System
#   Copyright (C) 2003 Bob MacCallum
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License ($PERLGP_BASE/LICENSE) for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The original author's contact details are:
#   Bob MacCallum
#   Stockholm Bioinformatics Center
#   Stockholm University, 106 91 Stockholm, Sweden.
#   WWW: http://perlgp.org  EMAIL: info AT perlgp DOT org


use BaseAlgorithm;

@ISA = qw(BaseAlgorithm);

sub _init {
  my ($self, %p) = @_;

  my %defaults = ( );

  $self->SUPER::_init(%defaults, %p);

  $self->compulsoryParams(qw(TrainingSet TestingSet)); # files or directories
  $self->optionalParams(qw(TrainingData TestingData)); # data structures
}


# load up the data sets (when needed)
# $self->T*ingData is just a (scalar ref to a) data structure
sub loadData {
  my ($self) = @_;

  $self->TrainingData($self->loadSet($self->TrainingSet));
  $self->TestingData($self->loadSet($self->TestingSet));
}

sub loadSet {
  my ($self, $fileordir) = @_;

  die "you must implement the Algorithm::loadSet() method\n";
}

sub fitnessFunction {
  my ($self, %p) = @_;

  die "you must implement the Algorithm::fitnessFunction() method\n";
}

sub saveOutput {
  my ($self, %p) = @_;

  die "you must implement the Algorithm::saveOutput() method\n";
}

1;
